#!/usr/bin/env bash
set -euo pipefail
BASE_HOME="${1:-$HOME}"

APP_ROOT="${BASE_HOME}/public_html/app"
WS_ROOT="${BASE_HOME}/public_html/ws"

mkdir -p "${APP_ROOT}" "${WS_ROOT}"
cp -f "$(pwd)/cpanel_templates/app/.htaccess" "${APP_ROOT}/.htaccess"
cp -f "$(pwd)/cpanel_templates/ws/.htaccess" "${WS_ROOT}/.htaccess"

echo "✅ Copied:"
echo " - ${APP_ROOT}/.htaccess"
echo " - ${WS_ROOT}/.htaccess"
