<?php
namespace App\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class DriverLocationUpdated implements ShouldBroadcastNow
{
    use InteractsWithSockets;

    public function __construct(
        public int $orderId,
        public float $lat,
        public float $lng,
        public ?float $heading = null,
        public ?float $speed = null
    ) {}

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('order.'.$this->orderId);
    }

    public function broadcastAs(): string
    {
        return 'driver.location';
    }
}
