<?php
namespace App\Events;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;

class TicketMessageCreated implements ShouldBroadcastNow
{
    use InteractsWithSockets;

    public function __construct(
        public int $ticketId,
        public int $senderId,
        public string $message,
        public string $createdAt
    ) {}

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('ticket.'.$this->ticketId);
    }

    public function broadcastAs(): string
    {
        return 'ticket.message';
    }
}
