<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DriverLocation;
use App\Models\Order;
use App\Events\DriverLocationUpdated;

class DriverLocationController extends Controller
{
    public function update(Request $request)
    {
        $user = $request->user();
        if ($user->role !== 'driver') return response()->json(['message'=>'Forbidden'], 403);

        $data = $request->validate([
            'lat' => 'required|numeric|between:-90,90',
            'lng' => 'required|numeric|between:-180,180',
            'heading' => 'nullable|numeric',
            'speed' => 'nullable|numeric',
            'accuracy' => 'nullable|numeric',
        ]);

        DriverLocation::updateOrCreate(
            ['driver_id'=>$user->id],
            $data
        );

        $order = Order::where('driver_id',$user->id)
            ->whereIn('status',['driver_accepted','picked_up'])
            ->latest()->first();

        if ($order) {
            event(new DriverLocationUpdated(
                $order->id,
                (float)$data['lat'],
                (float)$data['lng'],
                $data['heading'] ?? null,
                $data['speed'] ?? null
            ));
        }

        return response()->json(['ok'=>true]);
    }
}
