<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Payment;

class MoyasarController extends Controller
{
    public function create(Request $request)
    {
        $user = $request->user();
        $data = $request->validate([
            'order_id' => 'required|integer|exists:orders,id',
            'source' => 'required|string|in:creditcard,applepay,stcpay',
        ]);

        $order = Order::findOrFail($data['order_id']);
        if ((int)$order->customer_id !== (int)$user->id) return response()->json(['message'=>'Forbidden'], 403);

        $payment = Payment::create([
            'order_id'=>$order->id,
            'user_id'=>$user->id,
            'provider'=>'moyasar',
            'status'=>'initiated',
            'amount'=>$order->total,
            'currency'=>'SAR',
            'meta'=>['source'=>$data['source']],
        ]);

        $payload = [
            'amount' => (int) round($order->total * 100),
            'currency' => 'SAR',
            'description' => 'Order #'.$order->id,
            'callback_url' => config('app.url').'/payments/moyasar/callback?order_id='.$order->id,
            'metadata' => ['order_id'=>$order->id, 'payment_id'=>$payment->id],
        ];

        $ch = curl_init('https://api.moyasar.com/v1/payments');
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($payload),
            CURLOPT_USERPWD => env('MOYASAR_API_KEY').':',
        ]);
        $res = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($code >= 300) {
            return response()->json(['message'=>'Moyasar create failed','raw'=>$res], 422);
        }

        $json = json_decode($res, true);
        $payment->update([
            'provider_payment_id' => $json['id'] ?? null,
            'meta' => array_merge($payment->meta ?? [], ['moyasar'=>$json]),
        ]);

        $paymentUrl = $json['source']['transaction_url'] ?? $json['source']['url'] ?? null;

        return response()->json([
            'payment_id'=>$payment->id,
            'provider_payment_id'=>$payment->provider_payment_id,
            'payment_url'=>$paymentUrl,
        ]);
    }
}
