<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Payment;
use App\Models\PaymentWebhook;
use App\Models\Order;
use App\Events\OrderStatusUpdated;

class MoyasarWebhookController extends Controller
{
    public function handle(Request $request)
    {
        PaymentWebhook::create([
            'provider'=>'moyasar',
            'event_type'=>$request->input('type'),
            'provider_payment_id'=>$request->input('data.id') ?? $request->input('id'),
            'payload'=>$request->all(),
        ]);

        $providerPaymentId = $request->input('data.id') ?? $request->input('id');
        if (!$providerPaymentId) return response()->json(['ok'=>true]);

        $payment = Payment::where('provider','moyasar')->where('provider_payment_id',$providerPaymentId)->first();
        if (!$payment) return response()->json(['ok'=>true]);

        $status = $request->input('data.status') ?? $request->input('status');

        if ($status === 'paid' && $payment->status !== 'paid') {
            $payment->status = 'paid';
            $payment->save();

            $order = Order::find($payment->order_id);
            if ($order && $order->status === 'pending') {
                $order->status = 'paid';
                $order->save();
                event(new OrderStatusUpdated($order->id, $order->status));
            }
        }

        if ($status === 'failed') {
            $payment->status = 'failed';
            $payment->save();
        }

        return response()->json(['ok'=>true]);
    }
}
