<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('companies', function (Blueprint $t) {
            $t->id();
            $t->string('name');
            $t->string('cr_number')->nullable();
            $t->string('vat_number')->nullable();
            $t->unsignedBigInteger('owner_user_id');
            $t->decimal('credit_limit', 12, 2)->default(0);
            $t->decimal('credit_used', 12, 2)->default(0);
            $t->boolean('auto_approve_credit_orders')->default(false);
            $t->enum('status', ['active','suspended'])->default('active');
            $t->timestamps();
            $t->index(['owner_user_id','status']);
        });

        Schema::create('company_users', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('company_id');
            $t->unsignedBigInteger('user_id');
            $t->enum('role', ['admin','buyer'])->default('buyer');
            $t->timestamps();
            $t->unique(['company_id','user_id']);
        });

        Schema::create('invoices', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('company_id');
            $t->unsignedBigInteger('order_id')->nullable();
            $t->string('invoice_no')->unique();
            $t->decimal('amount', 12, 2);
            $t->enum('status', ['unpaid','paid','overdue','refunded'])->default('unpaid');
            $t->timestamp('due_at')->nullable();
            $t->timestamps();
            $t->index(['company_id','status']);
        });

        Schema::create('credit_ledger', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('company_id');
            $t->enum('type', ['charge','refund','adjust','payment']);
            $t->decimal('amount', 12, 2);
            $t->string('ref_type')->nullable();
            $t->unsignedBigInteger('ref_id')->nullable();
            $t->json('meta')->nullable();
            $t->timestamps();
            $t->index(['company_id','type']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('credit_ledger');
        Schema::dropIfExists('invoices');
        Schema::dropIfExists('company_users');
        Schema::dropIfExists('companies');
    }
};
