<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('loyalty_accounts', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('user_id')->unique();
            $t->bigInteger('points_balance')->default(0);
            $t->enum('tier', ['silver','gold','vip'])->default('silver');
            $t->timestamps();
        });

        Schema::create('loyalty_transactions', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('user_id');
            $t->enum('type', ['earn','redeem','adjust']);
            $t->bigInteger('points');
            $t->json('meta')->nullable();
            $t->timestamps();
            $t->index(['user_id','type']);
        });

        Schema::create('referrals', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('referrer_user_id');
            $t->unsignedBigInteger('referred_user_id')->unique();
            $t->timestamp('rewarded_at')->nullable();
            $t->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('referrals');
        Schema::dropIfExists('loyalty_transactions');
        Schema::dropIfExists('loyalty_accounts');
    }
};
