<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('rfqs', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('company_id')->nullable();
            $t->unsignedBigInteger('user_id')->nullable();
            $t->string('title');
            $t->text('details')->nullable();
            $t->json('delivery_address')->nullable();
            $t->enum('status', ['open','closed','awarded','canceled'])->default('open');
            $t->timestamps();
        });

        Schema::create('rfq_items', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('rfq_id');
            $t->string('name');
            $t->decimal('qty', 12, 2)->default(1);
            $t->string('unit')->nullable();
            $t->timestamps();
            $t->index(['rfq_id']);
        });

        Schema::create('rfq_offers', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('rfq_id');
            $t->unsignedBigInteger('vendor_id');
            $t->decimal('total', 12, 2)->default(0);
            $t->decimal('delivery_fee', 12, 2)->default(0);
            $t->text('notes')->nullable();
            $t->enum('status', ['submitted','accepted','rejected'])->default('submitted');
            $t->timestamps();
            $t->index(['rfq_id','vendor_id']);
        });

        Schema::create('rfq_offer_items', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('rfq_offer_id');
            $t->unsignedBigInteger('rfq_item_id');
            $t->decimal('unit_price', 12, 2)->default(0);
            $t->decimal('subtotal', 12, 2)->default(0);
            $t->timestamps();
            $t->index(['rfq_offer_id']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('rfq_offer_items');
        Schema::dropIfExists('rfq_offers');
        Schema::dropIfExists('rfq_items');
        Schema::dropIfExists('rfqs');
    }
};
