<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('plans', function (Blueprint $t) {
            $t->id();
            $t->string('name')->unique();
            $t->decimal('price', 12, 2);
            $t->enum('period', ['monthly','yearly']);
            $t->json('benefits')->nullable();
            $t->boolean('active')->default(true);
            $t->timestamps();
        });

        Schema::create('subscriptions', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('user_id');
            $t->unsignedBigInteger('plan_id');
            $t->enum('status', ['active','canceled','expired'])->default('active');
            $t->timestamp('starts_at');
            $t->timestamp('ends_at');
            $t->boolean('renewal')->default(true);
            $t->timestamps();
            $t->index(['user_id','status']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('subscriptions');
        Schema::dropIfExists('plans');
    }
};
