<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\File;

class ModulesServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $modulesPath = app_path('Modules');
        if (!File::exists($modulesPath)) return;

        foreach (File::directories($modulesPath) as $moduleDir) {
            $route = $moduleDir . '/Routes/api.php';
            if (File::exists($route)) {
                $this->loadRoutesFrom($route);
            }

            $migrations = $moduleDir . '/Database/Migrations';
            if (File::exists($migrations)) {
                $this->loadMigrationsFrom($migrations);
            }
        }
    }
}
