<?php
namespace App\Services;

use App\Models\CommissionRule;
use App\Models\Order;
use App\Models\Vendor;

class CommissionService
{
    public function percentFor(Order $order, string $segment='b2c'): float
    {
        $vendor = Vendor::find($order->vendor_id);

        $r = CommissionRule::where('is_active',true)->where('scope','vendor_id')
            ->where('vendor_id',$order->vendor_id)->where('customer_segment',$segment)->first();
        if ($r) return (float)$r->percent;

        if ($vendor) {
            $r = CommissionRule::where('is_active',true)->where('scope','vendor_type')
                ->where('vendor_type',$vendor->type)->where('customer_segment',$segment)->first();
            if ($r) return (float)$r->percent;
        }

        $r = CommissionRule::where('is_active',true)->where('scope','global')->where('customer_segment',$segment)->first();
        return $r ? (float)$r->percent : 15.0;
    }
}
