<?php
namespace App\Services;

use App\Models\Order;
use App\Models\User;

class DispatchService
{
    public function assignNearestDriver(Order $order, float $radiusKm = 8.0): ?User
    {
        if (!$order->dropoff_lat || !$order->dropoff_lng) return null;

        $candidates = User::query()
            ->where('role', 'driver')
            ->whereHas('driverProfile', fn($q) => $q->where('is_online', true)->where('is_available', true))
            ->whereHas('driverLocation')
            ->with(['driverLocation','driverProfile'])
            ->limit(80)->get();

        $best = null; $bestD = 999999;
        foreach ($candidates as $driver) {
            $loc = $driver->driverLocation;
            if (!$loc) continue;
            if ($loc->updated_at->diffInSeconds(now()) > 180) continue;

            $d = $this->haversineKm((float)$order->dropoff_lat,(float)$order->dropoff_lng,(float)$loc->lat,(float)$loc->lng);
            if ($d <= $radiusKm && $d < $bestD) { $bestD=$d; $best=$driver; }
        }

        if ($best) {
            $order->driver_id = $best->id;
            $order->status = 'driver_assigned';
            $order->save();
            $best->driverProfile->update(['is_available'=>false]);
        }

        return $best;
    }

    private function haversineKm(float $lat1,float $lon1,float $lat2,float $lon2): float
    {
        $R=6371;
        $dLat=deg2rad($lat2-$lat1); $dLon=deg2rad($lon2-$lon1);
        $a=sin($dLat/2)**2 + cos(deg2rad($lat1))*cos(deg2rad($lat2))*sin($dLon/2)**2;
        return $R*(2*atan2(sqrt($a), sqrt(1-$a)));
    }
}
