<?php
namespace App\Services;

class GeoService
{
    // poly = [[lat,lng], ...]
    public function pointInPolygon(float $lat, float $lng, array $poly): bool
    {
        $inside = false;
        for ($i=0, $j=count($poly)-1; $i<count($poly); $j=$i++) {
            [$xi,$yi] = $poly[$i];
            [$xj,$yj] = $poly[$j];
            $intersect = (($yi > $lng) != ($yj > $lng)) &&
              ($lat < ($xj - $xi) * ($lng - $yi) / (($yj - $yi) ?: 1e-12) + $xi);
            if ($intersect) $inside = !$inside;
        }
        return $inside;
    }
}
