<?php
namespace App\Services;

use App\Models\Wallet;
use App\Models\WalletTransaction;
use Illuminate\Support\Facades\DB;

class WalletService
{
    public function walletForUser(int $userId): Wallet
    {
        return Wallet::firstOrCreate(['user_id'=>$userId]);
    }

    public function credit(int $userId, float $amount, string $reason, ?int $refId=null, array $meta=[]): void
    {
        DB::transaction(function () use ($userId,$amount,$reason,$refId,$meta) {
            $w = $this->walletForUser($userId);
            WalletTransaction::create([
                'wallet_id'=>$w->id,'type'=>'credit','amount'=>$amount,'reason'=>$reason,'ref_id'=>$refId,'meta'=>$meta
            ]);
            $w->increment('balance', $amount);
        });
    }

    public function debit(int $userId, float $amount, string $reason, ?int $refId=null, array $meta=[]): void
    {
        DB::transaction(function () use ($userId,$amount,$reason,$refId,$meta) {
            $w = $this->walletForUser($userId);
            if ($w->balance < $amount) abort(422, 'Insufficient wallet balance');
            WalletTransaction::create([
                'wallet_id'=>$w->id,'type'=>'debit','amount'=>$amount,'reason'=>$reason,'ref_id'=>$refId,'meta'=>$meta
            ]);
            $w->decrement('balance', $amount);
        });
    }
}
