<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('vendors', function (Blueprint $table) {
      $table->id();
      $table->foreignId('owner_user_id')->constrained('users')->cascadeOnDelete();
      $table->string('name');
      $table->string('type')->default('store'); // restaurant|grocery|store|service
      $table->string('phone')->nullable();
      $table->string('address')->nullable();
      $table->decimal('lat', 10, 7)->nullable();
      $table->decimal('lng', 10, 7)->nullable();
      $table->boolean('is_active')->default(true);
      $table->timestamps();
    });
  }
  public function down(): void { Schema::dropIfExists('vendors'); }
};
