<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('driver_profiles', function (Blueprint $table) {
      $table->id();
      $table->foreignId('user_id')->unique()->constrained('users')->cascadeOnDelete();
      $table->boolean('is_online')->default(false);
      $table->boolean('is_available')->default(true);
      $table->timestamps();
    });
  }
  public function down(): void { Schema::dropIfExists('driver_profiles'); }
};
