<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('driver_locations', function (Blueprint $table) {
      $table->id();
      $table->foreignId('driver_id')->unique()->constrained('users')->cascadeOnDelete();
      $table->decimal('lat', 10, 7);
      $table->decimal('lng', 10, 7);
      $table->decimal('heading', 8, 2)->nullable();
      $table->decimal('speed', 8, 2)->nullable();
      $table->decimal('accuracy', 8, 2)->nullable();
      $table->timestamps();
    });
  }
  public function down(): void { Schema::dropIfExists('driver_locations'); }
};
