<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('zones', function (Blueprint $table) {
      $table->id();
      $table->string('name');
      $table->boolean('is_active')->default(true);
      $table->json('polygon');
      $table->timestamps();
    });

    Schema::create('vendor_branches', function (Blueprint $table) {
      $table->id();
      $table->foreignId('vendor_id')->constrained()->cascadeOnDelete();
      $table->foreignId('zone_id')->nullable()->constrained('zones')->nullOnDelete();
      $table->string('name');
      $table->string('address')->nullable();
      $table->decimal('lat', 10, 7);
      $table->decimal('lng', 10, 7);
      $table->boolean('is_active')->default(true);
      $table->timestamps();
    });

    Schema::create('branch_hours', function (Blueprint $table) {
      $table->id();
      $table->foreignId('vendor_branch_id')->constrained('vendor_branches')->cascadeOnDelete();
      $table->tinyInteger('day_of_week');
      $table->time('open_time')->nullable();
      $table->time('close_time')->nullable();
      $table->boolean('is_closed')->default(false);
      $table->timestamps();
      $table->unique(['vendor_branch_id','day_of_week']);
    });
  }

  public function down(): void {
    Schema::dropIfExists('branch_hours');
    Schema::dropIfExists('vendor_branches');
    Schema::dropIfExists('zones');
  }
};
