<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('wallets', function (Blueprint $table) {
      $table->id();
      $table->foreignId('user_id')->unique()->constrained()->cascadeOnDelete();
      $table->decimal('balance', 12, 2)->default(0);
      $table->timestamps();
    });

    Schema::create('wallet_transactions', function (Blueprint $table) {
      $table->id();
      $table->foreignId('wallet_id')->constrained()->cascadeOnDelete();
      $table->string('type');
      $table->decimal('amount', 12, 2);
      $table->string('reason');
      $table->unsignedBigInteger('ref_id')->nullable();
      $table->json('meta')->nullable();
      $table->timestamps();
      $table->index(['reason','ref_id']);
    });
  }

  public function down(): void {
    Schema::dropIfExists('wallet_transactions');
    Schema::dropIfExists('wallets');
  }
};
