<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('commission_rules', function (Blueprint $table) {
      $table->id();
      $table->string('scope')->default('global');
      $table->string('vendor_type')->nullable();
      $table->unsignedBigInteger('vendor_id')->nullable();
      $table->string('customer_segment')->default('b2c');
      $table->decimal('percent', 5, 2)->default(15.00);
      $table->boolean('is_active')->default(true);
      $table->timestamps();
      $table->index(['scope','vendor_type','vendor_id','customer_segment']);
    });

    Schema::create('driver_bonus_rules', function (Blueprint $table) {
      $table->id();
      $table->string('period')->default('weekly');
      $table->integer('target_orders');
      $table->decimal('bonus_amount', 12, 2);
      $table->boolean('is_active')->default(true);
      $table->timestamps();
    });

    Schema::create('driver_bonus_payouts', function (Blueprint $table) {
      $table->id();
      $table->foreignId('driver_id')->constrained('users')->cascadeOnDelete();
      $table->string('period')->default('weekly');
      $table->date('period_start');
      $table->date('period_end');
      $table->integer('orders_count');
      $table->decimal('bonus_amount', 12, 2);
      $table->timestamps();
      $table->unique(['driver_id','period','period_start','period_end']);
    });
  }

  public function down(): void {
    Schema::dropIfExists('driver_bonus_payouts');
    Schema::dropIfExists('driver_bonus_rules');
    Schema::dropIfExists('commission_rules');
  }
};
