<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Vendor;
use App\Models\Product;
use App\Models\DriverProfile;
use App\Models\DriverLocation;

class DemoSeeder extends Seeder
{
    public function run(): void
    {
        $admin = User::firstOrCreate(
            ['email'=>'admin@demo.com'],
            ['name'=>'Admin','password'=>Hash::make('password'),'role'=>'admin']
        );

        $vendorUser = User::firstOrCreate(
            ['email'=>'vendor@demo.com'],
            ['name'=>'Vendor','password'=>Hash::make('password'),'role'=>'vendor']
        );

        $vendor = Vendor::firstOrCreate(
            ['owner_user_id'=>$vendorUser->id,'name'=>'Demo Grocery'],
            ['type'=>'grocery','is_active'=>true,'lat'=>21.543333,'lng'=>39.172778]
        );

        Product::firstOrCreate(['vendor_id'=>$vendor->id,'name'=>'مياه 24 عبوة'], ['price'=>18.00,'stock'=>200,'is_active'=>true]);
        Product::firstOrCreate(['vendor_id'=>$vendor->id,'name'=>'خبز'], ['price'=>3.00,'stock'=>200,'is_active'=>true]);

        for ($i=1; $i<=3; $i++) {
            $driver = User::firstOrCreate(
                ['email'=>"driver{$i}@demo.com"],
                ['name'=>"Driver {$i}",'password'=>Hash::make('password'),'role'=>'driver']
            );

            DriverProfile::updateOrCreate(['user_id'=>$driver->id], ['is_online'=>true,'is_available'=>true]);

            DriverLocation::updateOrCreate(['driver_id'=>$driver->id], [
                'lat'=>21.55 + ($i*0.002),
                'lng'=>39.17 + ($i*0.002),
                'speed'=>null,'accuracy'=>10,'heading'=>null,
            ]);
        }
    }
}
