<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Zone;
use App\Models\Vendor;
use App\Models\VendorBranch;
use App\Models\BranchHours;

class ZonesAndBranchesSeeder extends Seeder
{
    public function run(): void
    {
        $zone = Zone::updateOrCreate(
            ['name'=>'Jeddah North (MVP)'],
            ['is_active'=>true,'polygon'=>[
                [21.70, 39.05],
                [21.70, 39.35],
                [21.45, 39.35],
                [21.45, 39.05],
            ]]
        );

        $vendor = Vendor::first();
        if (!$vendor) return;

        $branch = VendorBranch::updateOrCreate(
            ['vendor_id'=>$vendor->id,'name'=>'Main Branch'],
            ['zone_id'=>$zone->id,'lat'=>21.543333,'lng'=>39.172778,'is_active'=>true,'address'=>'Jeddah']
        );

        for ($d=0; $d<=6; $d++) {
            BranchHours::updateOrCreate(
                ['vendor_branch_id'=>$branch->id,'day_of_week'=>$d],
                ['open_time'=>'09:00:00','close_time'=>'23:59:00','is_closed'=>false]
            );
        }
    }
}
