<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\OrderQuoteController;
use App\Http\Controllers\DriverLocationController;
use App\Http\Controllers\MoyasarController;
use App\Http\Controllers\MoyasarWebhookController;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\AdminTicketController;

Route::post('/auth/login', [AuthController::class, 'login']);

// Webhooks (no auth)
Route::post('/webhooks/moyasar', [MoyasarWebhookController::class,'handle']);

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/me', [AuthController::class, 'me']);

    // Broadcasting auth for private channels
    Route::post('/broadcasting/auth', function (Request $request) {
        return Broadcast::auth($request);
    });

    // Customer
    Route::get('/vendors', [VendorController::class, 'index']);
    Route::get('/vendors/{vendor}/products', [ProductController::class, 'byVendor']);
    Route::post('/orders/quote', [OrderQuoteController::class, 'quote']);
    Route::post('/orders', [OrderController::class, 'create']);
    Route::get('/orders/{order}', [OrderController::class, 'show']);

    // Payments
    Route::post('/payments/moyasar/create', [MoyasarController::class,'create']);

    // Vendor
    Route::get('/vendor/orders', [OrderController::class, 'vendorOrders']);
    Route::post('/vendor/orders/{order}/accept', [OrderController::class, 'vendorAccept']);

    // Driver
    Route::get('/driver/jobs', [OrderController::class, 'driverJobs']);
    Route::post('/driver/jobs/{order}/accept', [OrderController::class, 'driverAccept']);
    Route::post('/driver/jobs/{order}/decline', [OrderController::class, 'driverDecline']);
    Route::post('/driver/location', [DriverLocationController::class, 'update']);

    // Lifecycle
    Route::post('/orders/{order}/pickup', [OrderController::class, 'pickup']);
    Route::post('/orders/{order}/deliver', [OrderController::class, 'deliverWithOtp']);

    // Devices
    Route::post('/devices/register', [DeviceController::class,'register']);

    // Tickets
    Route::post('/tickets', [TicketController::class,'create']);
    Route::get('/tickets', [TicketController::class,'mine']);
    Route::get('/tickets/{ticket}', [TicketController::class,'show']);
    Route::post('/tickets/{ticket}/messages', [TicketController::class,'reply']);

    // Admin Tickets
    Route::get('/admin/tickets', [AdminTicketController::class,'index']);
    Route::post('/admin/tickets/{ticket}/assign', [AdminTicketController::class,'assign']);
    Route::post('/admin/tickets/{ticket}/status', [AdminTicketController::class,'status']);
});
