<?php

use Illuminate\Support\Facades\Broadcast;
use App\Models\Order;
use App\Models\Ticket;

// Private order channel
Broadcast::channel('order.{orderId}', function ($user, $orderId) {
    $order = Order::find($orderId);
    if (!$order) return false;

    if ((int)$order->customer_id === (int)$user->id) return true;
    if ($order->driver_id && (int)$order->driver_id === (int)$user->id) return true;

    $vendor = \App\Models\Vendor::find($order->vendor_id);
    if ($vendor && (int)$vendor->owner_user_id === (int)$user->id) return true;

    if ($user->role === 'admin') return true;
    return false;
});

// Private ticket channel
Broadcast::channel('ticket.{ticketId}', function ($user, $ticketId) {
    $ticket = Ticket::find($ticketId);
    if (!$ticket) return false;

    if ((int)$ticket->user_id === (int)$user->id) return true;
    if ($user->role === 'admin') return true;
    if ($ticket->assigned_admin_id && (int)$ticket->assigned_admin_id === (int)$user->id) return true;

    return false;
});
