import Link from "next/link";

export default function DriverLanding() {
  return (
    <div dir="rtl">
      <div className="nav">
        <div className="container navInner">
          <div className="brand">
            <img src="/assets/logo.svg" alt="Almatajer" style={{ height: 34 }} />
            <span className="pill">بوابة السائق • تتبع مباشر + بونص أسبوعي</span>
          </div>
          <div style={{ display:"flex", gap:10, flexWrap:"wrap" }}>
            <Link className="btn btnGhost" href="/login">دخول</Link>
            <a className="btn btnGold" href="https://app.almatajer.net" target="_self">الصفحة الرئيسية</a>
          </div>
        </div>
      </div>

      <section className="hero">
        <div className="container heroGrid">
          <div className="card cardPad">
            <h1 className="h1">اربح أكثر… مع بونص أسبوعي</h1>
            <div className="sub">
              استلام مهام قريبة، تتبع مباشر، وOTP للتسليم — مع مكافآت عند تحقيق عدد طلبات.
            </div>
            <div className="row">
              <Link className="btn btnGold" href="/login">دخول السائق</Link>
              <a className="btn btnGhost" href="https://app.almatajer.net/tickets" target="_self">الدعم</a>
            </div>

            <div className="kpis" dir="rtl">
              <div className="kpi"><b>Live Tracking</b><span>يظهر للعميل لحظة بلحظة</span></div>
              <div className="kpi"><b>OTP</b><span>تسليم آمن برمز</span></div>
              <div className="kpi"><b>Bonus</b><span>مكافآت أسبوعية حسب الإنجاز</span></div>
            </div>
          </div>

          <div className="card">
            <img className="heroImg" src="/assets/hero-1.png" alt="hero" />
          </div>
        </div>
      </section>
    </div>
  );
}
