import Echo from "laravel-echo";
import Pusher from "pusher-js";
import { getToken } from "./auth";

export function makeEcho() {
  (window as any).Pusher = Pusher;

  const token = getToken();

  return new Echo({
    broadcaster: "pusher",
    key: process.env.NEXT_PUBLIC_REVERB_APP_KEY!,
    wsHost: process.env.NEXT_PUBLIC_REVERB_HOST!,
    wsPort: Number(process.env.NEXT_PUBLIC_REVERB_PORT || 80),
    wssPort: Number(process.env.NEXT_PUBLIC_REVERB_PORT || 443),
    forceTLS: (process.env.NEXT_PUBLIC_REVERB_SCHEME || "http") === "https",
    enabledTransports: ["ws", "wss"],

    authEndpoint: `${process.env.NEXT_PUBLIC_API_URL}/api/broadcasting/auth`,
    auth: {
      headers: {
        Authorization: token ? `Bearer ${token}` : "",
        Accept: "application/json",
      },
    },
  });
}
